<?php

include_once('bitacora.php');

/**
* Clase singletone para conectarse a la base de datos
*/
Class Conexion
{
	private static $instancia = NULL;
	private static $conexion = NULL;
	private $ultimo_resultado;

	private static $host = 'localhost';
	private static $port = '5432';
	private static $user = 'ctf_usuario_';
	private static $userSistema = 'ctf_sistema';
	private static $passwrd = 'changepassword';
	private static $passwrdSistema = 'changepassword';
	private static $dbname = 'ctf-2013';
/* -------------------------------------- */

	private function __construct($str = "")
	{
		$str = 'host='.self::$host.' port='.self::$port.' user='.self::$user.$_SESSION['participante_id'].' password='.self::$passwrd.' dbname='.self::$dbname;
		self::$conexion = pg_connect($str) or die ("Error: " . pg_last_error(self::$conexion));
	}

	/**
	* Obtener la instancia del singleton
	*/
	public static function GetInstancia()
	{
		if(self::$instancia == NULL) self::$instancia = new self();

		return self::$instancia;
	}

	function __destruct()
	{
	       pg_close(self::$conexion);
   	}

	/**
	* Ejecutar una consulta
	* @return resource
	* @param string $sql Sql a ejecutar
	*/
	function Ejecutar($sql)
	{
		return $this->last_result = pg_query(self::$conexion, $sql);
	}

	/**
	* Get the last error message
	* @return string Error description
	*/
	function LastError()
	{
		return pg_last_error(self::$conexion);
	}

	/**
	* Get the last error message
	* @return string Error description
	*/
	function Logout()
	{
		session_destroy();
	}

	function autenticarUsuario($mail, $contrasenha){
		$mail = addslashes($mail);
		$contrasenha = addslashes($contrasenha);

		$c_str = 'host='.self::$host.' port='.self::$port.' user='.self::$userSistema.' password='.self::$passwrdSistema.' dbname='.self::$dbname;
		$c = pg_connect($c_str);
		$r = pg_query($c, "select check_password('$mail','$contrasenha')");
		$result = pg_result($r, 0, 0);
		
		return $result;
	}

	function crearParticipante($nombre, $mail, $contrasenha, $administrador){
		$c_str = 'host='.self::$host.' port='.self::$port.' user='.self::$userSistema.' password='.self::$passwrdSistema.' dbname='.self::$dbname;
		$c = pg_connect($c_str);
		$esAdministrador = $administrador ? 't' : 'f';
		$r = pg_query($c, "select crear_participante('$nombre', '$mail','$contrasenha', '$esAdministrador')");
		$result = pg_result($r, 0, 0);
		
		return $result;
	}
	
	function eliminarParticipante($mail){
		$c_str = 'host='.self::$host.' port='.self::$port.' user='.self::$userSistema.' password='.self::$passwrdSistema.' dbname='.self::$dbname;
		$c = pg_connect($c_str);
		$r = pg_query($c, "select borrar_participante('$mail')");
		$result = pg_result($r, 0, 0);
		
		return $result;
	}
	
	function ObtenerParticipantes(){
		$c_str = 'host='.self::$host.' port='.self::$port.' user='.self::$userSistema.' password='.self::$passwrdSistema.' dbname='.self::$dbname;
		$c = pg_connect($c_str);
		$r = pg_query($c, "select * from participantes");
		
		return $r;
	}
	
	function EsAdmin($participante_id){
		$c_str = 'host='.self::$host.' port='.self::$port.' user='.self::$userSistema.' password='.self::$passwrdSistema.' dbname='.self::$dbname;
		$c = pg_connect($c_str);
		$r = pg_query($c, "select admin from participantes where id = $participante_id");
		$result = pg_result($r, 0, 0);
		
		return $result === 't';
	}

	function ObtenerNombre($participante_id){
		$c_str = 'host='.self::$host.' port='.self::$port.' user='.self::$userSistema.' password='.self::$passwrdSistema.' dbname='.self::$dbname;
		$c = pg_connect($c_str);
		$r = pg_query($c, "select nombre from participantes where id = $participante_id");
		
		if ($r && pg_num_rows($r) > 0)
		{
			$row = pg_fetch_row($r);
			return $row[0];
		}  

		return "";
	}

	function restablecerDatos($participante_id){
		$c_str = 'host='.self::$host.' port='.self::$port.' user='.self::$userSistema.' password='.self::$passwrdSistema.' dbname='.self::$dbname;
		$c = pg_connect($c_str);
		$r = pg_query($c, "select restablecer_datos($participante_id)");
		$result = pg_result($r, 0, 0);
		
		return $result;
	}

}
?>
